#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Simple Height Field CircleMod01.fsh     by    Chango  
//https://www.shadertoy.com/view/W3cGDl
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract
//start common
float GetTestHeight1( vec2 uv)
{
    float h = 5.0*length(uv-vec2(0.5,0.5));
    h=pow(h,3.0);
    return h;
}

float GetTestHeight2( vec2 uv)
{
    float h = 4.0*max(0.0,1.0-length(uv-vec2(0.5,0.5))/1.5);
    h=pow(h,3.0);
    return h;
}

float SingleRingWaveHeight(vec2 uv,float t)
{
    float ringDis = 1.0*(t);
    float ringWidth = 0.1;
    float dis = length(uv-vec2(0.5,0.5));
    float disToRing = abs(dis-ringDis);
    float k = min(1.0,disToRing/ringWidth);
    k = 1.0-k;
    float h = smoothstep(0.0,1.0,k);
    return h*4.0;
}

float GetHeightField(vec2 uv,float t)
{
    return 
    SingleRingWaveHeight(uv,t);
    +SingleRingWaveHeight(uv,t-0.02)
    +SingleRingWaveHeight(uv,t-0.04);
}

vec3 GetTestNorm1(float h,float hx1,float hy1)
{
    vec3 vx = vec3(1.0,0.0,hx1-h);
    vec3 vy = vec3(0.0,1.0,hy1-h);
    vec3 n = normalize(cross(vx,vy));
    if(n.z<0.0)
    {
        n = -n;
    }
    
    return n;
}

vec2 GetSampleUV(vec3 n,float h, vec2 uv)
{
    return uv-h*(n.xy/n.z);
}
//end common

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    //(intend scaled)
    vec2 uv = fragCoord/iResolution.xy;
    
    //---
    float t = fract(0.2*iTime);
    float h = GetHeightField(uv,t);
    vec2 delta = 1.0/iResolution.xy;
    float hx1 = GetHeightField(uv+vec2(delta.x,0.0),t);
    float hy1 = GetHeightField(uv+vec2(0.0,delta.y),t);
    
    vec3 n = GetTestNorm1(h,hx1,hy1);
    
    vec2 uv_sample =GetSampleUV(n,h,uv);
    //___
    
    //---
    uv_sample = mix(uv,uv_sample,t);
    //___
    
    //---
    vec3 col = texture2D(texture0,uv_sample).rgb;
    //col = vec3(n.x,0.0*n.y,0.0*n.z)*10.0;
    //col = vec3(1.0,1.0,1.0)*hx1;
    //___

    //Output to screen
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

